<!DOCTYPE html>
<html lang="de">
<head>
	<meta charset="UTF-8">
	<title>Gold and Outlaws</title>
	<link rel="stylesheet" type="text/css" href="css/master.css">
<?php
	/* Einbinden der jeweiligen CSS-Dateien und Javascript-Skripte*/
	session_start();
	if(!isset($_SESSION["username"])) {
		echo '<link rel="stylesheet" type="text/css" href="css/landing_page.css">';
		echo '<script src="js/login.js"></script>';		
	} else {
		echo '<link rel="stylesheet" type="text/css" href="css/game.css">';
		if (isset($_POST["stats"])) {
			echo '<link rel="stylesheet" type="text/css" href="css/stats.css">';
		}
	}
?>
	 	
</head>
<body>	
	<div id="wrapper">
	<!-- Header -->
		<header class="clearfix">
			<a href="index.php" title="Zur Hauptseite"><img src="img/Bandit_Logo_00.png" alt="Logo" width="256" height="128"></a>			
			<h2>Gold and Outlaws</h2>
		</header>
<?php

	//echo '<p id="test"></p>';
	
	require_once 'php/classes/account.class.php';
	/*echo '<pre>';
	echo 'Session:<br>';
	var_dump($_SESSION);
	echo 'Post:<br>';
	var_dump($_POST);
	echo '</pre>';*/

	if(!isset($_SESSION["username"])) {
		// Spieler ist nicht eingeloggt, sonst würde $_SESSION["username"] gesetzt sein
		
		if (isset($_POST["form"])) {

			// Spieler will sich einloggen oder registrieren

			switch ($_POST["form"]) {
				case 'login':
					$myAccount = Account::login($_POST["username"], $_POST["password"]);

					break;
				
				case 'register':
					$info = $myAccount = Account::register($_POST["r_username"], $_POST["r_password1"], $_POST["r_password2"], $_POST["r_email"], $_POST["r_cityname"]);					
					include 'php/landing_page.php';
					break;

				case 'logout':
					// Wenn der Back-Button benutzt wird. Ausschließlich zu Fehlerabfrage
					include 'php/landing_page.php';
					break;

				default:
					die();
					break;
			}
			
		} else {
			// keine Post-Daten vorhanden, Datei wurde zum ersten Mal aufgerufen oder aktualisiert
			include 'php/landing_page.php';
		}		
		
	} else {
		// Spieler ist eingeloggt
		// Daten holen
		$myAccount = Account::getById($_SESSION["id"]);

		// Spieler hat sich gerade eingeloggt -> last_login setzen
		if (isset($_SESSION["login"])) {
			$mysqltime = date ("Y-m-d H:i:s", time());
			$myAccount->last_login = $mysqltime;
		}

		
		if (isset($_POST["form"]) && $_POST["form"] == 'logout') {
			// Spieler will sich ausloggen		
			$info = $myAccount->logout();			
		} else {
			// Spieler spielt			
			require_once 'php/classes/goldmine.class.php';
			// Goldmine einbinden			
			$goldmine = goldmine::getById($myAccount->goldmine);

			/*echo '<pre>';
			echo 'Account:<br>';
			var_dump($myAccount);
			echo '</pre>';*/

			if (isset($_POST["game"])) {
				switch ($_POST["game"]) {
					case 'collect':
						// Wenn der Gold-Einsammeln-Button gedrückt wird	
						$info = $myAccount->collect();
						break;
					case 'upgrade':
						// Wenn der Goldmine-Upgrade-Button gedrückt wird
						$info = $myAccount->upgrade();
						$goldmine = goldmine::getById($myAccount->goldmine);
						break;
					case 'recruit':
						// Wenn neue Einheiten gebaut werden sollen
						$info = $myAccount->recruit($_POST["recruit_count"]);
						break;
					case 'heal':
						// Wenn Einheiten geheilt werden sollen
						$info = $myAccount->heal();
						break;
					case 'attack':
						// Wenn ein Spieler angegriffen wird
						$info = $myAccount->attack();
						break;
					case 'opponent':
						// Wenn ein neuer Gegner gesucht werden soll
						$info = $myAccount->find_enemy();
						break;					
					default:
						die();
						break;				
				}
				include 'php/main_page.php';
			} else if (isset($_POST["stats"])) {
				switch ($_POST["stats"]) {
					case 'highscore':
						$myAccount->highscore();						
						break;
					
					case 'kampfbericht':
						if (isset($_POST["helper"])){
							if ($_POST["helper"] == 'vor') {
								$_SESSION["kb"]++;
							} else if ($_POST["helper"] == 'zurueck') {
								$_SESSION["kb"]--;
							}
						}
						$myAccount->kampfbericht($_SESSION["kb"]);
						break;

					default:
						die();
						break;
				}
			} else {
				include 'php/main_page.php';
			}
			
		}
		// Daten setzen
		$myAccount->setById($myAccount->id);
		/*echo '<pre>';
		var_dump($myAccount);
		echo '</pre>';*/
	}
?>

	<!-- Footer -->
		<footer>
			<ul>
				<li><a href="impressum.html" title="Impressum">Impressum</a></li>				
			</ul>
			<p>&copy; Marius Alexy 2015</p>
		</footer>
	</div>
</body>
</html>