<?php 
	require_once 'php/classes/goldmine.class.php';
	class Account {
		public $id;
		public $name;
		public $email;
		public $created;
		public $last_login;
		public $last_logout;

		public $cityname;
		public $goldmine;
		public $gold;
		public $last_collect;
		public $truppen;
		public $injured;
		public $heal_time;
		public $heal_count;
		public $revive;
		public $enemy_id;
		public $enemy_name;

		const SERVER_START = '2015-05-29 12:00:00';
		const SERVER = 'localhost';
		const DATENBANK = 'gamegame';
		const USER = 'gamegame';
		const PW = 'emagemag';

		/* checkSQL überprüft die vom Benutzer eingegebenen Daten auf SQL-Injektionen 
		Input: ein Array mit den zu prüfenden Daten
		Output: ein "sauberes" Array */
		static function checkSQL($SQL_Data) {
			$dbconn = new mysqli(self::SERVER, self::USER, self::PW, self::DATENBANK);
			if (mysqli_connect_error()) {
				die ('Verbindungsfehler (' . mysqli_connect_errno() . ') ' . mysqli_connect_error());
			}
			$dbconn->set_charset('utf8');
			foreach ($SQL_Data as $key => $value) {
				$MYSQL_Clean[$key] = $dbconn->real_escape_string($value);				
			}
			$dbconn->close();
			return $MYSQL_Clean;
		}

		/* connect stellt die Verbindung zur Datenbank her und führt die Abfrage durch
		Input: ein SQL-Request
		Output: das Ergebnis des Requests */
		static function connect($sql) {
			$dbconn = new mysqli(self::SERVER, self::USER, self::PW, self::DATENBANK);
			if (mysqli_connect_error()) {
				die ('Verbindungsfehler (' . mysqli_connect_errno() . ') ' . mysqli_connect_error());
			}
			$dbconn->set_charset('utf8');
			$result = $dbconn->query($sql);
			$dbconn->close();
			return $result;
		}

		/* getById holt die Daten des Spielers vom Server
		Input: die ID, mit der der Spieler identifiziert wird
		Output: ein Objekt mit den Daten des Spielers */
		static function getById($id) {
			$sql = "SELECT id, name, created, last_login, last_logout, cityname, goldmine, gold, last_collect, truppen, injured, heal_time, heal_count, revive, enemy_id, enemy_name FROM user WHERE id=$id";
			$result = self::connect($sql);			 
			$obj = null;
			if ($result) {
				if ($obj = $result->fetch_object('Account')) {
					$result->free();
				}
			}			
			return $obj;
		}

		/* setById setzt die Daten des Spielers
		Input: die ID, mit der der Spieler identifiert wird
		Output: Falls das Setzen der Daten fehlerhaft ist, wird ein Fehlermeldung ausgegeben.*/
		function setById($id) {
			$sql = "UPDATE user SET 
			last_login = '$this->last_login', 
			last_logout = '$this->last_logout', 
			gold = '$this->gold', 
			last_collect = '$this->last_collect', 
			goldmine = '$this->goldmine', 
			truppen = '$this->truppen', 
			injured = '$this->injured',
			heal_time = '$this->heal_time',
			heal_count = '$this->heal_count',
			revive = '$this->revive',
			enemy_id = '$this->enemy_id',
			enemy_name = '$this->enemy_name'
			WHERE id=$id";
			$result = self::connect($sql);
			if (!$result === TRUE) {
				$_SESSION["meldung"] = '<p class="info_red">Fehler beim Speichern der Daten</p>';
				/*echo '<pre>';
				var_dump($this);
				echo '</pre>';*/
				session_regenerate_id();
				header('Location: index.php');				
			}			
		}

		/* register registriert einen neuen Benutzer
		Input: die Werte der Eingabefelder aus der Registrierungs-Form
		Output: 
		Falls erfolgreich eine entsprechende Meldung
		Falls nicht erfolgreich die entsprechenden Fehlermeldung(en)*/
		static function register($username, $password, $password2, $email, $cityname) {
			// Zuerst generelles Prüfen der Fehlermeldungen
			$return = '';
			$fehler = false;
			if (strlen($username) < 3) {
				$return .= '<p class="info_red">Username muss mindestens 3 Buchstaben enthalten</p>';
				$fehler = true;
			} else {
				if (!filter_var($username, FILTER_VALIDATE_REGEXP, array("options"=>array("regexp"=>"/^[a-zA-ZöäüÖÄÜ\s]*$/")))) {
					$return .= '<p class="info_red">Username darf nur Buchstaben enthalten.</p>';
				}
			}
			if (strlen($cityname) < 3) {
				$return .= '<p class="info_red">Stadtname muss mindestens 3 Buchstaben enthalten</p>';
				$fehler = true;
			} else {
				if (!filter_var($cityname, FILTER_VALIDATE_REGEXP, array("options"=>array("regexp"=>"/^[a-zA-ZöäüÖÄÜ\s]*$/")))) {
					$return .= '<p class="info_red">Stadtname darf nur Buchstaben enthalten.</p>';
				}	
			}
			if (!filter_var($email, FILTER_VALIDATE_EMAIL)){
				$return .= '<p class="info_red">Keine gültige E-Mail angegeben</p>';
			}
			if (strlen($password) < 3) {
				$return .= '<p class="info_red">Das Passwort muss mindestens drei Zeichen lang sein</p>';
				$fehler = true;
			}
			if ($password != $password2) {
				$return .= '<p class="info_red">Die Passwörter stimmen nicht überein</p>';
				$fehler = true;
			}

			// Falls die Eingaben nicht stimmen, wird direkt die Funktion verlassen
			if($fehler) {				
				return $return;
			}

			// Prüfen der Eingaben aus SQL-Injektionen
			$MYSQL["username"] = $username;
			$MYSQL["password"] = $password;
			$MYSQL["email"] = $email;
			$MYSQL["cityname"] = $cityname;			
			$MYSQL_Clean = self::checkSQL($MYSQL);
			
			// Verschlüsselung des Passwortes
			$password = md5($MYSQL_Clean['password']);

			// Prüfen, ob bereits ein Nutzer mit dem gleichen Namen anelegt ist
			$sql = "SELECT id FROM user WHERE name LIKE '$MYSQL_Clean[username]'";
			$result = self::connect($sql);
			/*echo '<pre>';
			echo 'MYSQL-Clean:<br>';
			var_dump($result);
			echo '</pre>';*/
			$menge = mysqli_num_rows($result);
			$result->free();

			// Nutzer anlegen
			if($menge == 0)	{
				$mysqltime = date ("Y-m-d H:i:s", time());
				$created = $mysqltime;
				$last_login = $mysqltime;
				$last_collect = self::SERVER_START;				
				$sql = "INSERT INTO user 
				(name, password, email, created, last_login, cityname, last_collect) VALUES 
				('$MYSQL_Clean[username]', '$password', '$MYSQL_Clean[email]', '$created', '$last_login', '$MYSQL_Clean[cityname]', '$last_collect')";
				
				$success = self::connect($sql);
				// Nutzer einloggen
				if ($success === TRUE) {
					// Daten holen
					$sql = "SELECT id, name FROM user WHERE name LIKE '$MYSQL_Clean[username]'";
					$result = self::connect($sql);
					if ($result) {
						while ($row = $result->fetch_assoc()) {
							
							$_SESSION["username"] = $row["name"];
							$_SESSION["id"] = $row["id"];
							$_SESSION["kb"] = 0;
							$_SESSION["meldung"] = '<p class="info_green">Account erfolgreich angelegt</p>';
							$result->free();
							session_regenerate_id();
							header('Location: index.php');
						}

					} else {
						$return = '<p class="info_red">Spieldaten angelegt, aber einloggen fehlgeschlagen</p>';
					}
					//$_SESSION["username"] = $username;
					//$_SESSION["id"] = $id;
					
				} else {
					$return =  '<p class="info_red">Fehler beim Anlegen der Spieldaten</p>';
				}
				
			} else {
				$return = '<p class="info_red">Benutzername schon vorhanden</p>';
			}
			
			return $return;
		}


		/* login loggt einen bestehenden Nutzer ein 
		Input: die Werte der Eingabefelder aus der Login-Form
		Output: Je nach Erfolg der Funktion eine entsprechende (Fehler-)Meldung */
		static function login($username, $password) {

			// Prüfen auf SQL-Injektion
			$MYSQL["username"] = $username;
			$MYSQL["password"] = $password;
			$MYSQL_Clean = self::checkSQL($MYSQL);			

			$sql = "SELECT id, name, password FROM user WHERE name LIKE '$MYSQL_Clean[username]' LIMIT 1";			
			$result = self::connect($sql);
			$MYSQL_Clean["password"] = md5($MYSQL_Clean["password"]);

			//$result = $dbconn -> query($sql);*/
			/*echo '<pre>';
			echo 'Result:';
			var_dump($MYSQL_Clean);
			echo '</pre>';*/

			//Einloggen
			if ($result) {				
				while ($row = $result->fetch_assoc()) {
					if ($row["password"] == $MYSQL_Clean["password"]) {
						$_SESSION["username"] = $row["name"];
						$_SESSION["id"] = intval($row["id"]);
						$_SESSION["kb"] = 0;
						$_SESSION["meldung"] = '<p class="info_green">Erfolgreich eingeloggt</p>';
						$result->free();
						session_regenerate_id();
						header('Location: index.php');
					}
				}

				$info = '<p class="info_red">Login fehlgeschlagen</p>';
				include 'php/landing_page.php';									
				$result->free();
			} else {
				echo 'Fehler bei der Datenbankverbindung aufgetreten';
			}
		}

		/* logout loggt den Spieler aus 
		Output: Entsprechende (Fehler-)Meldungen*/

		function logout() {			
			session_unset();
			$mysqltime = date ("Y-m-d H:i:s", time());
			$this->last_logout = $mysqltime;
			$sql = "UPDATE user SET last_logout = '$this->last_logout' WHERE id='$this->id'";
			$result = self::connect($sql);			
			if ($result === TRUE) {
				session_regenerate_id();
				$_SESSION["meldung"] = '<p class="info_green">Erfolgreich ausgeloggt</p>';
				header('Location: index.php');
			} else {
				session_regenerate_id();
				$_SESSION["meldung"] = '<p class="info_red">Fehler beim Ausloggen aufgetreten</p>';
				header('Location: index.php');
			}			
		}

		/* collect sammelt das Gold, das seit dem letzten Sammeln generiert wurde 
		Output: Entsprechende (Fehler-)Meldungen*/
		function collect() {			
			$lc_time = mktime(intval(substr($this->last_collect, 11,2)), intval(substr($this->last_collect, 14,2)), intval(substr($this->last_collect, 17,2)), intval(substr($this->last_collect, 5,2)), intval(substr($this->last_collect, 8,2)), intval(substr($this->last_collect, 0,4)));			
			$goldmine = goldmine::getById($this->goldmine);
			// Prüfen, ob mind. 1 Gold gesammelt werden kann
			if ($goldmine->produce * ((time() - $lc_time) / 3600) > 1) {
				// Ermitteln der Goldmenge
				$production = floor($goldmine->produce * ((time() - $lc_time) / 3600));

				$this->gold = $this->gold + $production;
				$mysqltime = date ("Y-m-d H:i:s", time());
				$this->last_collect = $mysqltime;
				$return = '<p class="info_green">Gold eingesammelt [' . number_format($production,0,',','.') .  ']</p>';
			} else {
				$return = '<p class="info_red">Kein Gold eingesammelt</p>';
			}
			return $return;
		}

		/* upgrade erhöht die Stufe der Goldmine
		Output: Entsprechende (Fehler-)Meldungen*/
		function upgrade() {
			$goldmine = goldmine::getById($this->goldmine);
			if ($goldmine->upgrade_cost <= $this->gold) {
				// Generiertes Gold sammeln
				$this->collect();
				// Gold für den Bau abziehen
				$this->gold = $this->gold - $goldmine->upgrade_cost;
				// Stufe erhöhen
				$this->goldmine = $this->goldmine + 1;
				$return = '<p class="info_green">Upgrade durchgeführt [' . number_format($goldmine->upgrade_cost,0,',','.') .  ' Gold abegezogen]</p>';
			} else {
				$return = '<p class="info_red">Upgrade fehlgeschlagen [' . number_format($goldmine->upgrade_cost - $this->gold,0,',','.') .  ' Gold benötigt]</p>';
			}
			return $return;
		}

		/* recruit stellt neue Truppen her
		Input: Der vom Spieler eingegebene Wert
		Output: Entsprechende (Fehler-)Meldungen*/
		function recruit($count) {
			//echo $count;
			/*var_dump($count);
			var_dump(intval($count));*/
			if (is_int(intval($count)) && intval($count) > 0) {
				$count = intval($count);
				if ($this->gold > $count) {
					$this->gold = $this->gold - $count; // evtl. noch Kosten für Truppen einbauen
					$this->truppen = $this->truppen + $count;
					$return = '<p class="info_green">' . number_format($count,0,',','.') .  ' Outlaws rekrutiert</p>';
				} else {
					$return = '<p class="info_red">Outlaws nicht rekrutiert [' . number_format($count - $this->gold,0,',','.') .  ' Gold benötigt]</p>';
				}
			} else {
				$return = '<p class="info_red">Keine Zahl eingegeben</p>';
			}
			return $return;
		}

		/* attack führt einen Angriff auf einen anderen Spieler durch
		Output: Entsprechende (Fehler-)Meldungen*/
		function attack() {
			if ($this->enemy_id == 0) {
				$return = '<p class="info_red">Bitte erst einen Gegner suchen</p>';				
			} else {
				$myEnemy = self::getById($this->enemy_id);
				/*echo '<pre>';
				echo 'Ich:<br>';
				var_dump($this);
				echo 'Enemy:<br>';
				var_dump($myEnemy);
				echo '</pre>';*/

				// Kampfscript

				$luckDB = rand(-10, 10);
				$luck = $luckDB / 100;
				//echo $luck . '<br>';
				$winner = (($this->truppen - $this->injured) * (1 + $luck)) - ($myEnemy->truppen - $myEnemy->injured);
				if ($winner >= 0) {
					$winner = 1;
				} else {
					$winner = 2;
				}

				$Truppen_Spieler = $this->truppen - $this->injured;
				$Truppen_Gegner = $myEnemy->truppen - $myEnemy->injured;

				if ($winner == 1) {
					// Sieger
					//echo 'Sieger' . '<br>';

					//Überlebende ermitteln
					$survivor = floor($Truppen_Spieler - $Truppen_Gegner);
					//echo $survivor . '<br>';

					//Verluste ermitteln
					$injured_ratio_Spieler = rand(30,60)/100;
					$Injured_Spieler = floor($Truppen_Gegner*$injured_ratio_Spieler);
					$injured_ratio_Gegner = rand(20,50)/100;
					$Injured_Gegner = floor($Truppen_Gegner*$injured_ratio_Gegner);
					$this->injured = $this->injured + $Injured_Spieler;
					$myEnemy->injured = $myEnemy->injured + $Injured_Gegner;

					//Plünderung ermitteln
					if ($survivor<$myEnemy->gold) {
						$loot = $survivor;
						$myEnemy->gold = $myEnemy->gold - $survivor;						
					} else {
						$loot = $myEnemy->gold;
						$myEnemy->gold = 0;
					}
					$this->gold = $this->gold + $loot;
					//echo $loot . '<br>';
					$return = '<p class="info_green">Kampf gewonnen. ' . number_format($loot,0,',','.') .  ' Gold erbeutet. ' . number_format($Injured_Spieler,0,',','.') . ' Outlaws verletzt</p>';

				} else {
					// Verlierer
					//echo 'Verlierer' . '<br>';

					$survivor = floor($Truppen_Gegner - $Truppen_Spieler);

					//Verluste ermitteln
					$injured_ratio_Spieler = rand(20,50)/100;
					$Injured_Spieler = floor($Truppen_Spieler*$injured_ratio_Spieler);
					$injured_ratio_Gegner = rand(20,50)/100;
					$Injured_Gegner = floor($Truppen_Spieler*$injured_ratio_Gegner);
					$this->injured = $this->injured + $Injured_Spieler;
					$myEnemy->injured = $myEnemy->injured + $Injured_Gegner;
					$loot = 0;
					$return = '<p class="info_red">Kampf verloren. ' . number_format($Injured_Spieler,0,',','.') . ' Outlaws verletzt</p>';				
				}

				$fighttime = date ("Y-m-d H:i:s", time());
				
				$sql = "INSERT INTO kampfberichte 
				(a_name, a_truppen, a_verletzt,
				v_name, v_truppen, v_verletzt,
				winner, stadtname, zeit, luck, loot) VALUES 
				('$this->name', '$Truppen_Spieler', '$Injured_Spieler', 
				'$myEnemy->name', '$Truppen_Gegner', '$Injured_Gegner',
				'$winner', '$myEnemy->cityname', '$fighttime', '$luckDB', '$loot')";
				$success = self::connect($sql);

				$myEnemy->setById($myEnemy->id);
				self::find_enemy();
			}
			return $return;
		}

		/* heal schickt Ärzte los oder heilt die Truppen, wenn die Ärzte angegekommen sind 
		Output: Entsprechende (Fehler-)Meldungen*/
		function heal() {
			// Zeit setzen, darstellen, Zeit steigert sich pro Tag
			// Ermitteln, was ein Tag anhand der Unix-Zeit ist
			
			$lh_time = mktime(intval(substr($this->heal_time, 11,2)), intval(substr($this->heal_time, 14,2)), intval(substr($this->heal_time, 17,2)), intval(substr($this->heal_time, 5,2)), intval(substr($this->heal_time, 8,2)), intval(substr($this->heal_time, 0,4)));


			if ($lh_time < time()) {
				if (floor($lh_time/86400) < floor(time()/86400) ){
					$this->heal_count = 0;					
				}
				if ($this->revive == 1) {
					$this->injured = 0;
					$this->revive = 0;
					$return = '<p class="info_green">Alle Verletzten sind wieder geheilt</p>';
				} else {					
					$i = 1;
					$this->heal_count++;
					$heal_timer = 300;
					while ($i < $this->heal_count) {
						$heal_timer = $heal_timer * 2;
						$i++;
					}
					$this->heal_time = date ("Y-m-d H:i:s", time() + $heal_timer);
					$this->revive = 1;

					if (floor((time()+$heal_timer)/86400) > floor(time()/86400)) {
						$this->heal_count = 0;
					}

					$return = '<p class="info_green">Ärzte losgeschickt - Eintreffen: ' . $this->heal_time . '</p>';
				}
			} else {
				// nichts - Ärzte noch unterwegs
				$return = '<p class="info_red">Die Ärzte sind noch unterwegs - Eintreffen: ' . $this->heal_time . '</p>';
			}
			return $return;
		}

		/* find_enemy sucht einen neuen Gegner in der Datenbank
		Output: Entsprechende (Fehler-)Meldungen*/
		function find_enemy() {
			//echo '<pre>';
			$sql = "SELECT id, name FROM user";
			$result = self::connect($sql);

			if ($result) {
				$menge = mysqli_num_rows($result);
				if ($menge == 1) {
					$this->enemy_id = 0;
					$this->enemy_name = '';
					$return = '<p class="info_green">Nicht genügend Spieler vorhanden</p>';
				} else {
					/*echo '<pre>';
					var_dump($menge);
					var_dump($result);
					echo '</pre>';*/
					$enemy_old = $this->enemy_id;
					$this->enemy_id = $this->id;
					$myRow = array();
					$a = 0;
					while ($row = $result->fetch_assoc()) {
						foreach ($row as $key => $value) {
							$myRow[$key][$a] = $value;
							//$a++;
						}
						$a++;
					}									
					if ($menge > 2) {
						$count = 0;
						$new_enemy = rand(0, $menge-1);
						while (($myRow["id"][$new_enemy] == $this->id) || ($myRow["id"][$new_enemy] == $enemy_old)) {
							$new_enemy = rand(0, $menge-1);					
						}
						$this->enemy_id = $myRow["id"][$new_enemy];
						$this->enemy_name = $myRow["name"][$new_enemy];
						$return = '<p class="info_green">Neuen Gegner ermittelt</p>';
					} else {
						$return = '<p class="info_green">Nur ein weiterer Mitspieler - Gegner bleibt gleich</p>';
					}
					
				}
				$result->free();
			} else {
				$return = '<p class="info_red">Fehler beim Gegner finden aufgetreten</p>';
			}
			//echo '</pre>';
			return $return;
		}

		/* highscore lädt die Highscore und zeigt sie an
		Output: Entsprechende (Fehler-)Meldungen*/
		function highscore() {
			$sql = "SELECT name, cityname, gold FROM user ORDER BY gold DESC";
			$result = self::connect($sql);
			if ($result) {
				$myRow = array();
				$a = 0;
				while ($row = $result->fetch_assoc()) {
					foreach ($row as $key => $value) {
						$myRow[$a][$key] = $value;
						//$a++;
					}
					$a++;
				}
				$result->free();
				$return = '<p class="info_green">Highscore geladen</p>';
			} else {
				$return = '<p class="info_red">Fehler beim Laden der Highscore aufgetreten</p>';

			}
			/*echo '<pre>';
			var_dump($myRow);
			echo '</pre>';*/
			$info = $return;
			include 'php/highscore.php';
		}

		/* kampfbericht sucht entsprechende Kampfberichte
		Output: Entsprechende (Fehler-)Meldungen*/
		function kampfbericht($number) {
			$sql = "SELECT a_name, a_truppen, a_verletzt, v_name, v_truppen, v_verletzt, winner, stadtname, zeit, luck, loot FROM kampfberichte WHERE a_name = '$this->name' OR v_name = '$this->name' LIMIT $number,1";
			$result = self::connect($sql);
			//$session_kb_old = $_SESSION["kb"];
			//echo '<pre>';
			if ($result) {
				$menge = mysqli_num_rows($result);				
				if ($menge == 1) {
					$myRow = array();
					while ($row = $result->fetch_assoc()) {
						foreach ($row as $key => $value) {
							$myRow[$key] = $value;
						}
						//echo 'myrow:';
						//var_dump($myRow);
					}
					if (!isset($_SESSION["meldung"])){
						$_SESSION["meldung"] = '<p class="info_green">Kampfbericht geladen</p>';
					}
					include 'php/kampfbericht.php';
				} else {
					// hier springt er bei > rein
					// oder wenn noch keiner drin ist
					//echo 'else menge: ' . $_SESSION["kb"];
					if ($_SESSION["kb"] != 0) {
						$_SESSION["kb"]--;
						$_SESSION["meldung"] = '<p class="info_red">Kein weiterer Bericht verfügbar</p>';
						self::kampfbericht($_SESSION["kb"]);
					} else {
						$info = '<p class="info_red">Keine Kampfberichte vorhanden</p>';
						include 'php/fehler.php';
					}
					
					//self::kampfbericht($_SESSION["kb"]);
				}
				$result->free();
				
			} else {
				// Hier springt er bei -1 rein
				//echo 'else result: ' . $_SESSION["kb"];
				$_SESSION["kb"] = 0;
				$_SESSION["meldung"] = '<p class="info_red">Kein früherer Bericht verfügbar</p>';
				self::kampfbericht($_SESSION["kb"]);
			}
			//echo '</pre>';
			
		}
	}

?>